﻿Imports System.Data.SqlClient
Imports CrystalDecisions.CrystalReports.Engine
Imports CrystalDecisions.Shared
Public Class frmApprovedStokRequest
    Dim rpt As New rptAprovedStockReq()
    Dim deptDs, rejStockDs As New DataSet
    Dim deptDa, rejStockDa As SqlDataAdapter
    Dim deptCodeArray(500) As String
    Dim stkAprCount As Integer
    Private Sub frmApprovedStokRequest_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Try
            Call Db_Connection()
            stkAprCount = Val(txtStocAprCount.Text)
            If stkAprCount = 0 Then
                rejStockDs.Reset()
                sql = "SELECT convert(varchar,A.SRQ_DATE, 103) AS DATE, A.SRQ_ITEMCODE, A.SRQ_QTY, A.SRQ_APROVEQTY, A.SRQ_REMARK, convert(varchar,A.SRQ_ITEMBEFORE,103)AS BEFORE_DATE, B.USR_EMPNAME, (E.USR_EMPNAME) AS APRVBY, (CASE WHEN (A.SRQ_STATUS = 1) THEN 'Aproved' ELSE 'Issued' END)AS STATUS, C.DEPT_DEPTNAME,D.ITM_ITEMDESC FROM STOCK_REQUEST AS A LEFT JOIN USER_MASTER AS B ON B.USR_EMPID=A.SRQ_REQUESTBY LEFT JOIN DEPARTMENT AS C ON C.DEPT_DEPTID = B.USR_DEPTID LEFT JOIN ITEMS AS D ON D.ITM_ITEMCODE=A.SRQ_ITEMCODE LEFT JOIN USER_MASTER AS E ON E.USR_EMPID=A.SRQ_APRVBY WHERE A.SRQ_STATUS <> 0 AND A.IS_DELETE=0 AND A.SRQ_STATUS <> 4 "
                rejStockDa = New SqlDataAdapter(sql, Mycn)
                rejStockDa.Fill(rejStockDs, DBNAME)

                rpt.SetDataSource(rejStockDs.Tables(DBNAME))
            Else
                rejStockDs.Reset()
                sql = "SELECT TOP " & stkAprCount & " convert(varchar,A.SRQ_DATE, 103) AS DATE, A.SRQ_ITEMCODE, A.SRQ_QTY, A.SRQ_APROVEQTY, A.SRQ_REMARK, convert(varchar,A.SRQ_ITEMBEFORE,103)AS BEFORE_DATE, B.USR_EMPNAME, (E.USR_EMPNAME) AS APRVBY, (CASE WHEN (A.SRQ_STATUS = 1) THEN 'Aproved' ELSE '' END)AS STATUS, C.DEPT_DEPTNAME,D.ITM_ITEMDESC FROM STOCK_REQUEST AS A LEFT JOIN USER_MASTER AS B ON B.USR_EMPID=A.SRQ_REQUESTBY LEFT JOIN DEPARTMENT AS C ON C.DEPT_DEPTID = B.USR_DEPTID LEFT JOIN ITEMS AS D ON D.ITM_ITEMCODE=A.SRQ_ITEMCODE LEFT JOIN USER_MASTER AS E ON E.USR_EMPID=A.SRQ_APRVBY WHERE A.SRQ_STATUS = 1 AND A.IS_DELETE=0 ORDER BY A.ID DESC "
                rejStockDa = New SqlDataAdapter(sql, Mycn)
                rejStockDa.Fill(rejStockDs, DBNAME)

                rpt.SetDataSource(rejStockDs.Tables(DBNAME))
                
            End If

            Dim objCompany As TextObject = DirectCast(rpt.ReportDefinition.Sections("Section2").ReportObjects("txtrptCompany"), TextObject)
            objCompany.Text = LGNCOMPNAME
            Dim objAddress As TextObject = DirectCast(rpt.ReportDefinition.Sections("Section2").ReportObjects("txtrptAddress"), TextObject)
            objAddress.Text = LGNCMPADDRESS
            CrystalReportViewer1.ReportSource = rpt
            LoadDepartment()
            txtStocAprCount.Text = 0
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub

    Private Sub btnGetDetails_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnGetDetails.Click
        Try
            Dim deptCode As String

            If cmbDepartment.SelectedIndex = -1 Then
                deptCode = ""
            Else
                deptCode = "AND C.DEPT_DEPTID = '" & deptCodeArray(cmbDepartment.SelectedIndex) & "'"
            End If

            rejStockDs.Reset()
            sql = "SELECT convert(varchar,A.SRQ_DATE, 103) AS DATE, A.SRQ_ITEMCODE, A.SRQ_QTY, A.SRQ_APROVEQTY, A.SRQ_REMARK, convert(varchar,A.SRQ_ITEMBEFORE,103)AS BEFORE_DATE, B.USR_EMPNAME, (E.USR_EMPNAME) AS APRVBY, (CASE WHEN (A.SRQ_STATUS = 1) THEN 'Aproved' ELSE 'Issued' END)AS STATUS, C.DEPT_DEPTNAME,D.ITM_ITEMDESC FROM STOCK_REQUEST AS A LEFT JOIN USER_MASTER AS B ON B.USR_EMPID=A.SRQ_REQUESTBY LEFT JOIN DEPARTMENT AS C ON C.DEPT_DEPTID = B.USR_DEPTID LEFT JOIN ITEMS AS D ON D.ITM_ITEMCODE=A.SRQ_ITEMCODE LEFT JOIN USER_MASTER AS E ON E.USR_EMPID=A.SRQ_APRVBY WHERE A.SRQ_STATUS <> 0 AND A.IS_DELETE=0 AND A.SRQ_STATUS <> 4 " & deptCode & " AND A.SRQ_DATE BETWEEN '" & dtpFromDate.Value.ToString("MM/dd/yyyy") & "' AND '" & dtpToDate.Value.ToString("MM/dd/yyyy") & "' "
            rejStockDa = New SqlDataAdapter(sql, Mycn)
            rejStockDa.Fill(rejStockDs, DBNAME)

            rpt.SetDataSource(rejStockDs.Tables(DBNAME))

            CrystalReportViewer1.ReportSource = rpt
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub
    Private Sub LoadDepartment()

        Try

            'LOAD DEPARTMENT
            sql = " SELECT DEPT_DEPTID, DEPT_DEPTNAME, CREATED_DATE FROM DEPARTMENT WHERE IS_DELETE = 0 "
            deptDa = New SqlDataAdapter(sql, Mycn)
            deptDa.Fill(deptDs, DBNAME)
            Dim rowCount = deptDs.Tables(DBNAME).Rows.Count
            cmbDepartment.Items.Clear()
            For i = 0 To rowCount - 1
                deptCodeArray(i) = deptDs.Tables(DBNAME).Rows(i).Item(0)
                cmbDepartment.Items.Add(deptDs.Tables(DBNAME).Rows(i).Item(1))
            Next
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try

    End Sub
End Class